# tkdvi.tcl -- Basic setup for TkDVI.
# Copyright  1999 Anselm Lingnau <lingnau@tm.informatik.uni-frankfurt.de>.
# See file COPYING for conditions on use and distribution.
# $Id: tkdvi.tcl,v 1.6 2001/08/02 08:31:39 anselm Exp $

package provide tkdvi 0.3

# The DVI package can be configured at load time by setting the
# following variables prior to the `package require Dvifont'. The
# values given here are the hard-coded defaults, which can be
# overridden in a `userInit' procedure.

# set dvi(makepk) 1
# set dvi(mfmode) ljfour
# set dvi(xresolution) 600
# set dvi(defaultfont) cmr10

package require Dvicf
package require Dvifont
package require Dviinterp
package require Dviimg
#package require Psimg

namespace eval tkdvi {
    variable version "Unspecified"
    variable count 0
}

namespace eval tkdvi::browser::special {}

proc tkdvi::version {{ver {}}} {
    variable version
    if {[string compare $ver {}] != 0} {
	set version $ver
    }
    return $version
}

proc tkdvi::reloadAll {} {
    foreach w [winfo children .] {
	if {[string match .tkdvi* $w]} {
	    tkdvi::browser::reload $w
	}
    }
}

proc tkdvi::openFileInNewWindow {{file {}} args} {
    variable count
    if {[string length $file]==0} {
	set types {
	    {{DVI Files} {.dvi}}
	    {{All Files} *}
	}
	set file [tk_getOpenFile -filetypes $types -title "Open DVI File"]
    }

    if {![file exists $file] && [string length [file extension $file]]==0} {
	append file ".dvi"
    }
    if {[catch {set f [dvi::code create -file $file]} msg]} {
	puts stderr "$file: $msg"
    } else {
	eval [list tkdvi::browser::browser .dvi$count] -file $f $args
	incr count
    }
}

proc tkdvi::cloneWindow {name args} {
    variable count
    set newName .dvi$count
    foreach c [$name configure] {
	set argv([lindex $c 0]) [lindex $c 4]
    }
    array set argv $args
    set file $argv(-file)
    unset argv(-file)
    if {[catch {eval tkdvi::browser::browser $newName \
	    -file $file [array get argv]} msg]} {
	return -code error "couldn't create $newName: $msg"
    } else {
	incr count
	return $newName
    }
}

package require tkdvi::menu
package require tkdvi::pagesel
package require tkdvi::browser
package require tkdvi::dialog
