# Generated by default/object.tt
package Paws::SecurityHub::AwsRedshiftClusterClusterParameterStatus;
  use Moose;
  has ParameterApplyErrorDescription => (is => 'ro', isa => 'Str');
  has ParameterApplyStatus => (is => 'ro', isa => 'Str');
  has ParameterName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsRedshiftClusterClusterParameterStatus

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsRedshiftClusterClusterParameterStatus object:

  $service_obj->Method(Att1 => { ParameterApplyErrorDescription => $value, ..., ParameterName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsRedshiftClusterClusterParameterStatus object:

  $result = $service_obj->Method(...);
  $result->Att1->ParameterApplyErrorDescription

=head1 DESCRIPTION

The status of a parameter in a cluster parameter group for an Amazon
Redshift cluster.

=head1 ATTRIBUTES


=head2 ParameterApplyErrorDescription => Str

The error that prevented the parameter from being applied to the
database.


=head2 ParameterApplyStatus => Str

The status of the parameter. Indicates whether the parameter is in sync
with the database, waiting for a cluster reboot, or encountered an
error when it was applied.

Valid values: C<in-sync> | C<pending-reboot> | C<applying> |
C<invalid-parameter> | C<apply-deferred> | C<apply-error> |
C<unknown-error>


=head2 ParameterName => Str

The name of the parameter.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

